/*
 * Decompiled with CFR 0.152.
 */
package com.ftdi.j2xx;

import com.ftdi.j2xx.D2xxManager;
import com.ftdi.j2xx.FT_Device;
import com.ftdi.j2xx.FT_EEPROM;
import com.ftdi.j2xx.FT_EEPROM_232HPQ;
import com.ftdi.j2xx.FT_EE_Ctrl;

class FT_EE_232HPQ_Ctrl
extends FT_EE_Ctrl {
    private static final byte EEPROM_SIZE_LOCATION = 15;
    private static final String DEFAULT_PID = "6045";
    private static final int AL_DRIVE_CURRENT = 3;
    private static final int BL_DRIVE_CURRENT = 768;
    private static final int AL_FAST_SLEW = 4;
    private static final int AL_SCHMITT_INPUT = 8;
    private static final int BL_FAST_SLEW = 1024;
    private static final int BL_SCHMITT_INPUT = 2048;
    private static FT_Device ft_device;

    FT_EE_232HPQ_Ctrl(FT_Device usbc) throws D2xxManager.D2xxException {
        super(usbc);
        this.getEepromSize((byte)15);
    }

    @Override
    short programEeprom(FT_EEPROM ee) {
        int[] dataToWrite = new int[this.mEepromSize];
        if (ee.getClass() != FT_EEPROM_232HPQ.class) {
            return 1;
        }
        FT_EEPROM_232HPQ eeprom = (FT_EEPROM_232HPQ)ee;
        try {
            short driveC;
            if (eeprom.FIFO) {
                dataToWrite[0] = dataToWrite[0] | 1;
            } else if (eeprom.FIFOTarget) {
                dataToWrite[0] = dataToWrite[0] | 2;
            } else if (eeprom.FastSerial) {
                dataToWrite[0] = dataToWrite[0] | 4;
            }
            if (eeprom.FT1248) {
                dataToWrite[0] = dataToWrite[0] | 8;
            }
            if (eeprom.LoadVCP) {
                dataToWrite[0] = dataToWrite[0] | 0x10;
            }
            if (eeprom.FT1248ClockPolarity) {
                dataToWrite[0] = dataToWrite[0] | 0x100;
            }
            if (eeprom.FT1248LSB) {
                dataToWrite[0] = dataToWrite[0] | 0x200;
            }
            if (eeprom.FT1248FlowControl) {
                dataToWrite[0] = dataToWrite[0] | 0x400;
            }
            if (eeprom.PowerSaveEnable) {
                dataToWrite[0] = dataToWrite[0] | 0x8000;
            }
            dataToWrite[1] = eeprom.VendorId;
            dataToWrite[2] = eeprom.ProductId;
            dataToWrite[3] = 2304;
            dataToWrite[4] = this.setUSBConfig(ee);
            dataToWrite[5] = this.setDeviceControl(ee);
            short driveA = eeprom.AL_DriveCurrent;
            if (driveA == -1) {
                driveA = 0;
            }
            dataToWrite[6] = dataToWrite[6] | driveA;
            if (eeprom.AL_SlowSlew) {
                dataToWrite[6] = dataToWrite[6] | 4;
            }
            if (eeprom.AL_SchmittInput) {
                dataToWrite[6] = dataToWrite[6] | 8;
            }
            if ((driveC = (short)eeprom.BL_DriveCurrent) == -1) {
                driveC = 0;
            }
            dataToWrite[6] = dataToWrite[6] | (short)(driveC << 8);
            if (eeprom.BL_SlowSlew) {
                dataToWrite[6] = dataToWrite[6] | 0x400;
            }
            if (eeprom.BL_SchmittInput) {
                dataToWrite[6] = dataToWrite[6] | 0x800;
            }
            int offset = 80;
            offset = this.setStringDescriptor(eeprom.Manufacturer, dataToWrite, offset, 7, false);
            offset = this.setStringDescriptor(eeprom.Product, dataToWrite, offset, 8, false);
            if (eeprom.SerNumEnable) {
                offset = this.setStringDescriptor(eeprom.SerialNumber, dataToWrite, offset, 9, false);
            }
            dataToWrite[10] = 0;
            dataToWrite[11] = 0;
            dataToWrite[12] = 0;
            byte c0 = eeprom.CBus0;
            int c1 = eeprom.CBus1;
            int c2 = eeprom.CBus2;
            int c3 = eeprom.CBus3;
            dataToWrite[12] = c0 | (c1 <<= 4) | (c2 <<= 8) | (c3 <<= 12);
            dataToWrite[13] = 0;
            byte c4 = eeprom.CBus4;
            int c5 = eeprom.CBus5;
            int c6 = eeprom.CBus6;
            int c7 = eeprom.CBus7;
            dataToWrite[13] = c4 | (c5 <<= 4) | (c6 <<= 8) | (c7 <<= 12);
            dataToWrite[14] = 0;
            byte c8 = eeprom.CBus8;
            int c9 = eeprom.CBus9;
            dataToWrite[14] = c8 | (c9 <<= 4);
            dataToWrite[15] = this.mEepromType;
            dataToWrite[69] = 72;
            if (this.mEepromType == 70) {
                return 1;
            }
            if (dataToWrite[1] != 0 && dataToWrite[2] != 0) {
                boolean returnCode = false;
                returnCode = this.programEeprom(dataToWrite, this.mEepromSize - 1);
                if (returnCode) {
                    return 0;
                }
                return 1;
            }
            return 2;
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
    }

    @Override
    FT_EEPROM readEeprom() {
        FT_EEPROM_232HPQ eeprom = new FT_EEPROM_232HPQ();
        int[] data = new int[this.mEepromSize];
        if (this.mEepromBlank) {
            return eeprom;
        }
        try {
            for (short i = 0; i < this.mEepromSize; i = (short)(i + 1)) {
                data[i] = this.readWord(i);
            }
            eeprom.UART = false;
            switch (data[0] & 0xF) {
                case 0: {
                    eeprom.UART = true;
                    break;
                }
                case 1: {
                    eeprom.FIFO = true;
                    break;
                }
                case 2: {
                    eeprom.FIFOTarget = true;
                    break;
                }
                case 4: {
                    eeprom.FastSerial = true;
                    break;
                }
                case 8: {
                    eeprom.FT1248 = true;
                    break;
                }
                default: {
                    eeprom.UART = true;
                }
            }
            if ((data[0] & 0x10) > 0) {
                eeprom.LoadVCP = true;
                eeprom.LoadD2XX = false;
            } else {
                eeprom.LoadVCP = false;
                eeprom.LoadD2XX = true;
            }
            eeprom.FT1248ClockPolarity = (data[0] & 0x100) > 0;
            eeprom.FT1248LSB = (data[0] & 0x200) > 0;
            eeprom.FT1248FlowControl = (data[0] & 0x400) > 0;
            if ((data[0] & 0x8000) > 0) {
                eeprom.PowerSaveEnable = true;
            }
            eeprom.VendorId = (short)data[1];
            eeprom.ProductId = (short)data[2];
            this.getUSBConfig(eeprom, data[4]);
            this.getDeviceControl(eeprom, data[5]);
            int data01x06 = data[6] & 3;
            switch (data01x06) {
                case 0: {
                    eeprom.AL_DriveCurrent = 0;
                    break;
                }
                case 1: {
                    eeprom.AL_DriveCurrent = 1;
                    break;
                }
                case 2: {
                    eeprom.AL_DriveCurrent = (byte)2;
                    break;
                }
                case 3: {
                    eeprom.AL_DriveCurrent = (byte)3;
                    break;
                }
            }
            eeprom.AL_SlowSlew = (data[6] & 4) > 0;
            eeprom.AL_SchmittInput = (data[6] & 8) > 0;
            short data89X06 = (short)((data[6] & 0x300) >> 8);
            switch (data89X06) {
                case 0: {
                    eeprom.BL_DriveCurrent = 0;
                    break;
                }
                case 1: {
                    eeprom.BL_DriveCurrent = 1;
                    break;
                }
                case 2: {
                    eeprom.BL_DriveCurrent = (byte)2;
                    break;
                }
                case 3: {
                    eeprom.BL_DriveCurrent = (byte)3;
                    break;
                }
            }
            eeprom.BL_SlowSlew = (data[6] & 0x400) > 0;
            eeprom.BL_SchmittInput = (data[6] & 0x800) > 0;
            short cbus0 = (short)(data[12] >> 0 & 0xF);
            eeprom.CBus0 = (byte)cbus0;
            short cbus1 = (short)(data[12] >> 4 & 0xF);
            eeprom.CBus1 = (byte)cbus1;
            short cbus2 = (short)(data[12] >> 8 & 0xF);
            eeprom.CBus2 = (byte)cbus2;
            short cbus3 = (short)(data[12] >> 12 & 0xF);
            eeprom.CBus3 = (byte)cbus3;
            short cbus4 = (short)(data[13] >> 0 & 0xF);
            eeprom.CBus4 = (byte)cbus4;
            short cbus5 = (short)(data[13] >> 4 & 0xF);
            eeprom.CBus5 = (byte)cbus5;
            short cbus6 = (short)(data[13] >> 8 & 0xF);
            eeprom.CBus6 = (byte)cbus6;
            short cbus7 = (short)(data[13] >> 12 & 0xF);
            eeprom.CBus7 = (byte)cbus7;
            short cbus8 = (short)(data[14] >> 0 & 0xF);
            eeprom.CBus8 = (byte)cbus8;
            short cbus9 = (short)(data[14] >> 4 & 0xF);
            eeprom.CBus9 = (byte)cbus9;
            int addr = data[7] & 0xFF;
            eeprom.Manufacturer = this.getStringDescriptor(addr /= 2, data);
            addr = data[8] & 0xFF;
            eeprom.Product = this.getStringDescriptor(addr /= 2, data);
            addr = data[9] & 0xFF;
            eeprom.SerialNumber = this.getStringDescriptor(addr /= 2, data);
            return eeprom;
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    int getUserSize() {
        int data = this.readWord((short)9);
        int ptr = data & 0xFF;
        ptr /= 2;
        int length = (data & 0xFF00) >> 8;
        length /= 2;
        return (this.mEepromSize - ++ptr - 1 - ++length) * 2;
    }

    @Override
    int writeUserData(byte[] data) {
        int i;
        int dataWrite = 0;
        short offset = 0;
        if (data.length > this.getUserSize()) {
            return 0;
        }
        int[] eeprom = new int[this.mEepromSize];
        for (i = 0; i < this.mEepromSize; i = (short)(i + 1)) {
            eeprom[i] = this.readWord((short)i);
        }
        offset = (short)(this.mEepromSize - this.getUserSize() / 2 - 1 - 1);
        for (i = 0; i < data.length; i += 2) {
            dataWrite = i + 1 < data.length ? data[i + 1] & 0xFF : 0;
            dataWrite <<= 8;
            short s = offset;
            offset = (short)(offset + 1);
            eeprom[s] = dataWrite |= data[i] & 0xFF;
        }
        if (eeprom[1] != 0 && eeprom[2] != 0) {
            boolean returnCode = false;
            returnCode = this.programEeprom(eeprom, this.mEepromSize - 1);
            if (!returnCode) {
                return 0;
            }
        } else {
            return 0;
        }
        return data.length;
    }

    @Override
    byte[] readUserData(int length) {
        byte Hi = 0;
        byte Lo = 0;
        int dataRead = 0;
        byte[] data = new byte[length];
        if (length == 0 || length > this.getUserSize()) {
            return null;
        }
        short offset = (short)(this.mEepromSize - this.getUserSize() / 2 - 1 - 1);
        for (int i = 0; i < length; i += 2) {
            short s = offset;
            offset = (short)(offset + 1);
            dataRead = this.readWord(s);
            if (i + 1 < data.length) {
                data[i + 1] = Hi = (byte)(dataRead & 0xFF);
            } else {
                Lo = 0;
            }
            data[i] = Lo = (byte)((dataRead & 0xFF00) >> 8);
        }
        return data;
    }
}

